/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.ars_creo.contraption;

import com.hollingsworth.ars_creo.network.ACNetworking;
import com.hollingsworth.ars_creo.network.PacketUpdateJarContraption;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.Spell;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.TurretSpellCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.block.CreativeSourceJar;
import com.hollingsworth.arsnouveau.common.block.SourceJar;
import com.hollingsworth.arsnouveau.common.block.tile.SourceJarTile;
import com.hollingsworth.arsnouveau.common.entity.EntityProjectileSpell;
import com.hollingsworth.arsnouveau.common.spell.method.MethodProjectile;
import com.hollingsworth.arsnouveau.common.spell.method.MethodTouch;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.PositionImpl;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public interface ITurretBehavior {
    default public void castSpell(MovementContext context, BlockPos pos) {
        ServerLevel world = (ServerLevel)context.world;
        Position iposition = this.getDispensePosition(pos, context.state);
        Direction direction = (Direction)context.state.m_61143_((Property)BasicSpellTurret.FACING);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        fakePlayer.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        TurretSpellCaster spellCaster = new TurretSpellCaster(context.tileData);
        Spell spell = spellCaster.getSpell();
        if (!spell.isValid()) {
            return;
        }
        EntitySpellResolver resolver = new EntitySpellResolver(new SpellContext(spell, (LivingEntity)fakePlayer).withType(SpellContext.CasterType.TURRET));
        if (!this.canTakeFromJar(context, spell.getCastingCost(), pos) && SourceUtil.takeSourceNearbyWithParticles((BlockPos)pos, (Level)world, (int)6, (int)spell.getCastingCost()) == null) {
            return;
        }
        if (resolver.castType instanceof MethodProjectile) {
            spellCaster.playSound(pos, (Level)world, null, spellCaster.getCurrentSound(), SoundSource.BLOCKS);
            this.shootProjectile(world, pos, (SpellResolver)resolver, context.state, context);
        } else if (resolver.castType instanceof MethodTouch) {
            BlockPos touchPos = new BlockPos(iposition.m_7096_(), iposition.m_7098_(), iposition.m_7094_());
            if (direction == Direction.WEST || direction == Direction.NORTH) {
                touchPos = touchPos.m_142300_(direction);
            }
            if (direction == Direction.DOWN) {
                touchPos = touchPos.m_7495_();
            }
            resolver.onCastOnBlock(new BlockHitResult(new Vec3((double)touchPos.m_123341_(), (double)touchPos.m_123342_(), (double)touchPos.m_123343_()), direction.m_122424_(), new BlockPos(touchPos.m_123341_(), touchPos.m_123342_(), touchPos.m_123343_()), false), (LivingEntity)fakePlayer);
        }
    }

    default public void shootProjectile(ServerLevel world, BlockPos pos, SpellResolver resolver, BlockState state, MovementContext context) {
        Vec3 facingVec = Vec3.m_82528_((Vec3i)((Direction)context.state.m_61143_((Property)BasicSpellTurret.FACING)).m_122436_());
        facingVec = (Vec3)context.rotation.apply(facingVec);
        facingVec.m_82541_();
        Vec3 effectiveMovementVec = facingVec.m_82490_(0.5).m_82549_(context.motion);
        FakePlayer fakePlayer = FakePlayerFactory.getMinecraft((ServerLevel)world);
        fakePlayer.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        EntityProjectileSpell spell = new EntityProjectileSpell((Level)world, resolver);
        spell.m_5602_((Entity)fakePlayer);
        double x = (double)pos.m_123341_() + facingVec.f_82479_ * 0.7 + 0.5;
        double y = (double)pos.m_123342_() + facingVec.f_82480_ * 0.7 + 0.5;
        double z = (double)pos.m_123343_() + facingVec.f_82481_ * 0.7 + 0.5;
        spell.m_6034_(x, y, z);
        spell.m_6686_(effectiveMovementVec.f_82479_, effectiveMovementVec.f_82480_, effectiveMovementVec.f_82481_, 0.4f, 0.0f);
        world.m_7967_((Entity)spell);
    }

    default public Direction getClosestFacingDirection(Vec3 exactFacing) {
        return Direction.m_122366_((double)exactFacing.f_82479_, (double)exactFacing.f_82480_, (double)exactFacing.f_82481_);
    }

    default public boolean canTakeFromJar(MovementContext context, int amount, BlockPos turretPos) {
        ServerLevel world = (ServerLevel)context.world;
        Map structureBlocks = context.contraption.getBlocks();
        for (StructureTemplate.StructureBlockInfo blockInfo : structureBlocks.values()) {
            int totalSource;
            if (blockInfo.f_74676_.m_60734_() instanceof CreativeSourceJar) {
                return true;
            }
            if (!(blockInfo.f_74676_.m_60734_() instanceof SourceJar) || (totalSource = blockInfo.f_74677_.m_128451_(SourceJarTile.SOURCE_TAG)) < amount) continue;
            int currentFillState = this.getFillState(totalSource);
            int adjustedAmount = totalSource - amount;
            int nextFillState = this.getFillState(adjustedAmount);
            blockInfo.f_74677_.m_128405_(SourceJarTile.SOURCE_TAG, adjustedAmount);
            if (currentFillState != nextFillState) {
                ACNetworking.sendToNearby((Level)world, turretPos, (Object)new PacketUpdateJarContraption(context.contraption.entity.m_142049_(), blockInfo.f_74675_, blockInfo.f_74677_, nextFillState));
            }
            return true;
        }
        return false;
    }

    default public int getFillState(int source) {
        int fillState = 0;
        if (source > 0 && source < 1000) {
            fillState = 1;
        } else if (source != 0) {
            fillState = source / 1000 + 1;
        }
        return fillState;
    }

    default public Position getDispensePosition(BlockPos pos, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)BasicSpellTurret.FACING);
        double d0 = (double)pos.m_123341_() + 0.5 * (double)direction.m_122429_();
        double d1 = (double)pos.m_123342_() + 0.5 * (double)direction.m_122430_();
        double d2 = (double)pos.m_123343_() + 0.5 * (double)direction.m_122431_();
        return new PositionImpl(d0, d1, d2);
    }
}

